/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  init.c
//  Initialization of the uC
//
//  Matthias Ulmann, Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//******************************************************************************


#include "main.h"



// General initializations
void init_general(void)
{  
  // set frequency of DCO to 16MHz, using calibrated register settings
  BCSCTL1 = CALBC1_16MHZ;
  DCOCTL = CALDCO_16MHZ;
  
  // select DCO for MCLK
  clear_bit(BCSCTL2, SELM0);
  clear_bit(BCSCTL2, SELM1);
  
  // no divider for MCLK
  clear_bit(BCSCTL2, DIVM0);
  clear_bit(BCSCTL2, DIVM1);
  
  // select DCO for SMCLK
  clear_bit(BCSCTL2, SELS);
  
  // no divider for SMCLK
  clear_bit(BCSCTL2, DIVS0);
  clear_bit(BCSCTL2, DIVS1);
  
  // disable second crystal oscillator XT2
  clear_bit(BCSCTL1, XT2OFF);

  // set divider 8 for ACLK
  set_bit(BCSCTL1, DIVA1);
  set_bit(BCSCTL1, DIVA0);
}



// Initialization of LCD backlight
// the backlight is switched on when the pin is high
void init_backlight(void)
{
	// set pin as output
	set_bit(BLIGHT_PDIR, BLIGHT_BIT);
	
	// disable pullup
	clear_bit(BLIGHT_RES, BLIGHT_BIT);
	
	// set I/O function
	clear_bit(BLIGHT_PSEL, BLIGHT_BIT);
	
	// set output low (LCD backlight off)
	clear_bit(BLIGHT_POUT, BLIGHT_BIT);
}



// Initialization of LED
// the LED is on when the pin is low
void init_led(void)
{
	// set pin as output
	set_bit(LED_PDIR, LED_BIT);
	
	// disable pullup
	clear_bit(LED_RES, LED_BIT);
	
	// set I/O function
	clear_bit(LED_PSEL, LED_BIT);
	
	// set output high (LED off)
	set_bit(LED_POUT, LED_BIT);	
}



// Initialization of enable output
// The converter is running when the output is low.
void init_enable(void)
{
	// set pin as output
	set_bit(ENABLE_PDIR, ENABLE_BIT);
	
	// disable pullup
	clear_bit(ENABLE_RES, ENABLE_BIT);
	
	// set I/O function
	clear_bit(ENABLE_PSEL, ENABLE_BIT);
	
	// set output high (pwr supply off)
	set_bit(ENABLE_POUT, ENABLE_BIT);	
}
